/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.cec;

import com.quantumdata.cec.CECComplianceCDFFeaturesMessages;
import com.quantumdata.cec.CECComplianceCDFGeneral;
import com.quantumdata.cec.CECComplianceMain;
import com.quantumdata.std.xml.DbNode;
import com.quantumdata.std.xml.DbUtil;
import com.quantumdata.widgets.QDPanel;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.Scanner;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class CECComplianceCDF
extends QDPanel {
    private static final long serialVersionUID = 1L;
    private JTabbedPane m_cdfTabs;
    private JScrollPane[] m_scrollPanes;
    private CECComplianceCDFGeneral generalTab;
    private CECComplianceCDFFeaturesMessages[] featuresMessagesTabs;
    private CECComplianceMain m_parent;
    private static final String[] deviceTypeNames = new String[]{"TV", "Recording Device", "Tuner", "Audio System", "CEC Switch", "Playback Device"};
    public static final String[] deviceTypeNamesAlt = new String[]{"TV/Display", "Recording Device", "Tuner, e.g. STB", "Audio System", "CEC Switch", "Playback Device, e.g. DVD"};
    public static final String[] uutTypes = new String[]{"Display", "Recorder", "SetTopBox", "AudioSys", "Repeater", "Player"};

    public CECComplianceCDF(CECComplianceMain cECComplianceMain) {
        int n;
        this.m_parent = cECComplianceMain;
        this.m_cdfTabs = new JTabbedPane();
        this.m_cdfTabs.setToolTipText("Devices will become enabled based on their support in the 'General' tab.");
        this.m_scrollPanes = new JScrollPane[7];
        this.generalTab = new CECComplianceCDFGeneral(this);
        this.featuresMessagesTabs = new CECComplianceCDFFeaturesMessages[6];
        this.m_scrollPanes[0] = new JScrollPane(this.generalTab.rightHandPanel, 20, 30);
        this.m_cdfTabs.addTab("General", this.m_scrollPanes[0]);
        for (int i = 0; i < 6; ++i) {
            this.featuresMessagesTabs[i] = new CECComplianceCDFFeaturesMessages();
            this.m_scrollPanes[i + 1] = new JScrollPane(this.featuresMessagesTabs[i], 20, 30);
            this.m_cdfTabs.addTab(deviceTypeNames[i] + " Features/Msgs", this.m_scrollPanes[i + 1]);
        }
        Dimension dimension = new Dimension(700, 500);
        for (n = 0; n < 7; ++n) {
            this.m_scrollPanes[n].setMaximumSize(dimension);
            this.m_scrollPanes[n].setMinimumSize(dimension);
            this.m_scrollPanes[n].setPreferredSize(dimension);
        }
        for (n = 0; n < this.m_cdfTabs.getTabCount(); ++n) {
            this.m_cdfTabs.setToolTipTextAt(n, "Devices will become enabled based on their support in the 'General' tab.");
        }
        this.add(this.generalTab.sidePanel);
        this.add(this.m_cdfTabs);
        for (n = 0; n < 6; ++n) {
            this.EnableTab(n, false);
        }
    }

    public void EnableTab(int n, boolean bl) {
        for (int i = 0; i < 7; ++i) {
            if (!this.m_cdfTabs.getTitleAt(i).equalsIgnoreCase(deviceTypeNames[n] + " Features/Msgs")) continue;
            this.m_cdfTabs.setEnabledAt(i, bl);
        }
    }

    public static String fixName(String string) {
        String string2 = string;
        string2 = string2.replace(' ', '_');
        string2 = string2.replace('?', 'Q');
        string2 = string2.replace('.', '_');
        string2 = string2.replace('[', '_');
        string2 = string2.replace(']', '_');
        string2 = string2.replace('\\', '_');
        string2 = string2.replace('/', '_');
        string2 = string2.replace(',', '_');
        return string2;
    }

    public void LoadCDF() {
        this.m_parent.LoadCDF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void LoadCDFFromCSV() {
        block14: {
            FileDialog fileDialog = new FileDialog((Frame)new JFrame(), "Load File", 0);
            fileDialog.setVisible(true);
            String string = fileDialog.getDirectory() + File.separatorChar + fileDialog.getFile();
            try {
                File file = new File(string);
                if (file.exists()) {
                    Scanner scanner = new Scanner(file);
                    try {
                        scanner.nextLine();
                        scanner.nextLine();
                        String[] stringArray = scanner.nextLine().split(",");
                        if (stringArray[0].equalsIgnoreCase("CEC Features / Messages Supported")) {
                            String string2 = "";
                            if (stringArray.length > 11) {
                                string2 = stringArray[11];
                            } else if (this.generalTab.GetNumOfDevs() == 1) {
                                string2 = deviceTypeNamesAlt[this.generalTab.GetFirstEnabledDev()];
                            }
                            if (string2.length() > 0) {
                                int n = -1;
                                for (int i = 0; i < deviceTypeNamesAlt.length; ++i) {
                                    if (!string2.equalsIgnoreCase(deviceTypeNamesAlt[i])) continue;
                                    n = i;
                                }
                                if (n != -1) {
                                    this.featuresMessagesTabs[n].LoadFromCSV(scanner);
                                }
                            }
                        } else {
                            this.generalTab.LoadFromCSV(scanner);
                        }
                        break block14;
                    }
                    finally {
                        scanner.close();
                    }
                }
                System.out.println("File " + string + " not found.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void SaveCDF() {
        String string;
        String string2;
        while (!(string2 = JOptionPane.showInputDialog(this, (Object)"Please provide a filename (without extension).")).equalsIgnoreCase(string = CECComplianceCDF.fixName(string2))) {
            int n = JOptionPane.showConfirmDialog(this, "<HTML>The filename provided is not valid.<br>Is <b>" + string + "</b> acceptable?</HTML>", "Is this okay?", 0);
            if (n != 0) continue;
            this.SaveCDFToFile(string);
            return;
        }
        this.SaveCDFToFile(string2);
    }

    public void UseCDF(int n) {
        this.m_parent.UseCDF(n);
    }

    public void SaveCDFToFile(String string) {
        DbNode dbNode = DbUtil.newDocument("DATAOBJ");
        DbNode dbNode2 = dbNode.createChild("HEADER");
        dbNode2.addAttr("TYPE", "CDF");
        dbNode2.addAttr("VERSION", "1.0");
        dbNode2 = dbNode.createChild("DATA");
        dbNode2 = dbNode2.createChild("CEC");
        DbNode dbNode3 = dbNode2.createChild("General");
        this.generalTab.SendCDFEntries(dbNode3);
        for (int i = 0; i < 6; ++i) {
            if (!this.m_cdfTabs.isEnabledAt(i + 1)) continue;
            dbNode3 = dbNode2.createChild("Device");
            dbNode3.addElement("DeviceIndex", i);
            this.featuresMessagesTabs[i].SendCDFEntries(dbNode3);
        }
        File file = new File("tmp.xml");
        DbUtil.saveDocument(dbNode, file);
        this.m_parent.CopyFileToFTP(string + ".xml", file);
    }

    public void GetCDFEntries(String string) {
        this.GetCDFEntries(DbUtil.loadDocument(string + ".xml", "DATAOBJ"));
    }

    public void GetCDFEntries(File file) {
        this.GetCDFEntries(DbUtil.loadDocument(file, "DATAOBJ"));
    }

    public void GetCDFEntries(DbNode dbNode) {
        DbNode dbNode2 = dbNode.getNode("HEADER");
        if (dbNode2.getAttr("TYPE").equalsIgnoreCase("CDF")) {
            dbNode = dbNode.getNode("DATA");
            dbNode = dbNode.getNode("CEC");
            DbNode dbNode3 = dbNode.getNode("General");
            this.generalTab.GetCDFEntries(dbNode3);
            for (int i = 0; i < dbNode.getNodeCount(); ++i) {
                dbNode2 = dbNode.getNode(i);
                if (dbNode2.getName() != "Device") continue;
                int n = dbNode2.getIntElement("DeviceIndex");
                this.featuresMessagesTabs[n].GetCDFEntries(dbNode2);
                this.EnableTab(n, true);
            }
        }
    }

    public static String GetStringTag(String string, String string2) {
        return "<" + string + ">" + string2 + "</" + string + ">\n";
    }

    public static String GetBoolTag(String string, boolean bl) {
        return CECComplianceCDF.GetStringTag(string, bl ? "1" : "0");
    }

    public static String GetIntTag(String string, int n) {
        return CECComplianceCDF.GetStringTag(string, Integer.toString(n));
    }
}

